/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.fuel;

import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;

public class Fuel {
    private final IIngredient<ItemStack> ingredient;
    private final int amount;
    private final float temperature;
    private final boolean isForgeValid;
    private final boolean isBloomeryValid;

    public Fuel(IIngredient<ItemStack> ingredient, int amount, float temperature) {
        this(ingredient, amount, temperature, false, false);
    }

    public Fuel(IIngredient<ItemStack> ingredient, int amount, float temperature, boolean isForgeValid, boolean isBloomeryValid) {
        this.ingredient = ingredient;
        this.amount = amount;
        this.temperature = temperature;
        this.isForgeValid = isForgeValid;
        this.isBloomeryValid = isBloomeryValid;
    }

    public boolean matchesInput(Fuel fuel) {
        for (ItemStack stack : fuel.ingredient.getValidIngredients()) {
            if (!this.matchesInput(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesInput(ItemStack stack) {
        return this.ingredient.testIgnoreCount(stack);
    }

    public int getAmount() {
        return this.amount;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public boolean isForgeFuel() {
        return this.isForgeValid;
    }

    public boolean isBloomeryFuel() {
        return this.isBloomeryValid;
    }
}

