/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.skills;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.util.skills.ProspectingSkill;
import net.dries007.tfc.util.skills.SimpleSkill;
import net.dries007.tfc.util.skills.Skill;
import net.dries007.tfc.util.skills.SmithingSkill;

public final class SkillType<S extends Skill> {
    public static final SkillType<ProspectingSkill> PROSPECTING;
    public static final SkillType<SmithingSkill> SMITHING;
    public static final SkillType<SimpleSkill> AGRICULTURE;
    public static final SkillType<SimpleSkill> BUTCHERING;
    private static final Map<String, SkillType<? extends Skill>> SKILL_TYPES;
    private static final List<SkillType<? extends Skill>> SKILL_ORDER;
    private final String name;
    private final Function<IPlayerData, S> skillSupplier;

    @Nonnull
    public static List<SkillType<? extends Skill>> getSkills() {
        return SKILL_ORDER;
    }

    @Nonnull
    public static Map<String, Skill> createSkillMap(IPlayerData rootInstance) {
        return SKILL_TYPES.values().stream().collect(Collectors.toMap(SkillType::getName, e -> (Skill)e.skillSupplier.apply(rootInstance)));
    }

    @Nullable
    public static <S extends Skill> SkillType<S> get(String name, Class<S> returnClass) {
        SkillType<? extends Skill> skill = SKILL_TYPES.get(name);
        try {
            return skill;
        }
        catch (ClassCastException e) {
            TerraFirmaCraft.getLog().warn("Tried to cast skill '" + skill + "' to an incorrect instance type: " + name + " / " + returnClass);
            return null;
        }
    }

    public SkillType(String name, Function<IPlayerData, S> skillSupplier) {
        this.name = name;
        this.skillSupplier = skillSupplier;
        if (SKILL_TYPES.containsKey(name)) {
            throw new IllegalArgumentException("Can't register multiple skills with the same name!");
        }
        SKILL_TYPES.put(name, this);
        SKILL_ORDER.add(this);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    static {
        SKILL_TYPES = new LinkedHashMap<String, SkillType<? extends Skill>>(4);
        SKILL_ORDER = new ArrayList<SkillType<? extends Skill>>(4);
        PROSPECTING = new SkillType<ProspectingSkill>("prospecting", ProspectingSkill::new);
        SMITHING = new SkillType<SmithingSkill>("smithing", SmithingSkill::new);
        AGRICULTURE = new SkillType<SimpleSkill>("agriculture", SimpleSkill::new);
        BUTCHERING = new SkillType<SimpleSkill>("butchering", SimpleSkill::new);
    }
}

