/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.skills;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.util.skills.Skill;
import net.dries007.tfc.util.skills.SkillTier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SmithingSkill
extends Skill {
    private static final String SKILL_VALUE = "tfc_smithing_value";
    private static final String SKILL_TYPE = "tfc_smithing_type";
    private final int[] skillLevels = new int[4];

    public static void applySkillBonus(SmithingSkill skill, ItemStack stack, Type bonusType) {
        if (bonusType != Type.GENERAL) {
            NBTTagCompound nbt;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((nbt = stack.func_77978_p()) != null) {
                nbt.func_74776_a(SKILL_VALUE, (float)skill.getSkillSum() / 160.0f);
                nbt.func_74768_a(SKILL_TYPE, bonusType.ordinal());
            }
        }
    }

    public static void copySkillBonus(ItemStack to, ItemStack from) {
        NBTTagCompound fromNbt = from.func_77978_p();
        if (fromNbt != null) {
            if (!to.func_77942_o()) {
                to.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound toNbt = to.func_77978_p();
            toNbt.func_74768_a(SKILL_TYPE, fromNbt.func_74762_e(SKILL_TYPE));
            toNbt.func_74776_a(SKILL_VALUE, fromNbt.func_74760_g(SKILL_VALUE));
        }
    }

    public static float getSkillBonus(ItemStack stack) {
        return SmithingSkill.getSkillBonus(stack, null);
    }

    public static float getSkillBonus(ItemStack stack, @Nullable Type type) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            return type == null || nbt.func_74762_e(SKILL_TYPE) == type.ordinal() ? nbt.func_74760_g(SKILL_VALUE) : 0.0f;
        }
        return 0.0f;
    }

    public SmithingSkill(IPlayerData rootSkills) {
        super(rootSkills);
    }

    @Override
    @Nonnull
    public SkillTier getTier() {
        return SkillTier.valueOf(this.getSkillSum() / 40);
    }

    @Override
    public float getLevel() {
        int totalSkill = this.getSkillSum();
        return totalSkill >= 160 ? 1.0f : (float)(totalSkill % 40) / 40.0f;
    }

    @Override
    public void setTotalLevel(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        for (Type smithType : Type.values()) {
            this.skillLevels[smithType.ordinal()] = (int)(value * (double)smithType.getMax());
        }
        this.updateAndSync();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Type type : Type.values()) {
            nbt.func_74768_a(type.name().toLowerCase(), this.skillLevels[type.ordinal()]);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            for (Type type : Type.values()) {
                this.skillLevels[type.ordinal()] = nbt.func_74762_e(type.name().toLowerCase());
            }
        }
    }

    public void addSkill(Type type, int amount) {
        int n = type.ordinal();
        this.skillLevels[n] = this.skillLevels[n] + amount;
        if (this.skillLevels[type.ordinal()] > type.getMax()) {
            this.skillLevels[type.ordinal()] = type.getMax();
        }
        this.updateAndSync();
    }

    private int getSkillSum() {
        int sum = 0;
        for (int skill : this.skillLevels) {
            sum += skill;
        }
        return sum;
    }

    public static enum Type {
        GENERAL(80),
        TOOLS(40),
        WEAPONS(20),
        ARMOR(20);

        private final int max;

        private Type(int max) {
            this.max = max;
        }

        public int getMax() {
            return this.max;
        }
    }
}

