/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.ClimateHelper;
import net.dries007.tfc.world.classic.CustomChunkPrimer;
import net.dries007.tfc.world.classic.DataLayer;
import net.dries007.tfc.world.classic.WorldEntitySpawnerTFC;
import net.dries007.tfc.world.classic.WorldGenSettings;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.genlayers.GenLayerTFC;
import net.dries007.tfc.world.classic.genlayers.datalayers.drainage.GenDrainageLayer;
import net.dries007.tfc.world.classic.genlayers.datalayers.ph.GenPHLayer;
import net.dries007.tfc.world.classic.mapgen.MapGenCavesTFC;
import net.dries007.tfc.world.classic.mapgen.MapGenRavineTFC;
import net.dries007.tfc.world.classic.mapgen.MapGenRiverRavine;
import net.dries007.tfc.world.classic.worldgen.RarityBasedWorldGen;
import net.dries007.tfc.world.classic.worldgen.WorldGenBerryBushes;
import net.dries007.tfc.world.classic.worldgen.WorldGenFalls;
import net.dries007.tfc.world.classic.worldgen.WorldGenFissure;
import net.dries007.tfc.world.classic.worldgen.WorldGenFruitTrees;
import net.dries007.tfc.world.classic.worldgen.WorldGenLargeRocks;
import net.dries007.tfc.world.classic.worldgen.WorldGenLooseRocks;
import net.dries007.tfc.world.classic.worldgen.WorldGenOreVeins;
import net.dries007.tfc.world.classic.worldgen.WorldGenSnowIce;
import net.dries007.tfc.world.classic.worldgen.WorldGenSoilPits;
import net.dries007.tfc.world.classic.worldgen.WorldGenSpikes;
import net.dries007.tfc.world.classic.worldgen.WorldGenTrees;
import net.dries007.tfc.world.classic.worldgen.WorldGenWildCrops;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.registries.ForgeRegistry;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ChunkGenTFC
implements IChunkGenerator {
    public static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    public static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    public static final IBlockState SALT_WATER = FluidsTFC.SALT_WATER.get().getBlock().func_176223_P();
    public static final IBlockState FRESH_WATER = FluidsTFC.FRESH_WATER.get().getBlock().func_176223_P();
    public static final IBlockState HOT_WATER = FluidsTFC.HOT_WATER.get().getBlock().func_176223_P();
    public static final IBlockState LAVA = Blocks.field_150353_l.func_176223_P();
    public static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    public static final IBlockState SNOW = Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(1));
    public static final IBlockState SALT_WATER_ICE = BlocksTFC.SEA_ICE.func_176223_P();
    public static final IBlockState FRESH_WATER_ICE = Blocks.field_150432_aD.func_176223_P();
    private static final float[] parabolicField = new float[25];
    private static final IWorldGenerator LAVA_FISSURE_GEN = new RarityBasedWorldGen(x -> x.lavaFissureRarity, new WorldGenFissure(true));
    private static final IWorldGenerator WATER_FISSURE_GEN = new RarityBasedWorldGen(x -> x.waterFissureRarity, new WorldGenFissure(false));
    private static final IWorldGenerator ORE_VEINS_GEN = new WorldGenOreVeins();
    private static final IWorldGenerator SOIL_PITS_GEN = new WorldGenSoilPits();
    private static final IWorldGenerator LARGE_ROCKS_GEN = new RarityBasedWorldGen(x -> x.largeRockRarity, new WorldGenLargeRocks());
    private static final IWorldGenerator TREE_GEN = new WorldGenTrees();
    private static final IWorldGenerator BERRY_BUSH_GEN = new WorldGenBerryBushes();
    private static final IWorldGenerator FRUIT_TREE_GEN = new WorldGenFruitTrees();
    private static final IWorldGenerator WILD_CROPS_GEN = new WorldGenWildCrops();
    private static final IWorldGenerator LOOSE_ROCKS_GEN = new WorldGenLooseRocks(true);
    private static final IWorldGenerator STALACTITE_GEN = new WorldGenSpikes(true, 300);
    private static final IWorldGenerator STALAGMITE_GEN = new WorldGenSpikes(false, 300);
    private static final IWorldGenerator WATERFALL_GEN = new WorldGenFalls(FRESH_WATER, 15);
    private static final IWorldGenerator LAVAFALL_GEN = new WorldGenFalls(Blocks.field_150356_k.func_176223_P(), 5);
    private static final IWorldGenerator SNOW_ICE_GEN = new WorldGenSnowIce();
    public final WorldGenSettings s;
    private final World world;
    private final long seed;
    private final Random rand;
    private final NoiseGeneratorOctaves noiseGen1;
    private final NoiseGeneratorOctaves noiseGen2;
    private final NoiseGeneratorOctaves noiseGen3;
    private final NoiseGeneratorOctaves noiseGen4;
    private final NoiseGeneratorOctaves noiseGen5;
    private final NoiseGeneratorOctaves noiseGen6;
    private final NoiseGeneratorOctaves mobSpawnerNoise;
    private final NoiseGeneratorPerlin noiseGen7;
    private final NoiseGeneratorPerlin noiseGen8;
    private final NoiseGeneratorPerlin noiseGen9;
    private final NoiseGeneratorPerlin noiseGen10;
    private final GenLayerTFC rocksGenLayer1;
    private final GenLayerTFC rocksGenLayer2;
    private final GenLayerTFC rocksGenLayer3;
    private final GenLayerTFC stabilityGenLayer;
    private final GenLayerTFC phGenLayer;
    private final GenLayerTFC drainageGenLayer;
    private final double[] noise1 = new double[425];
    private final double[] noise2 = new double[425];
    private final double[] noise3 = new double[425];
    private final double[] noise4 = new double[256];
    private final double[] noise5 = new double[425];
    private final double[] noise6 = new double[425];
    private final double[] heightMap = new double[425];
    private final Biome[] biomes = new Biome[324];
    private final DataLayer[] stabilityLayer = new DataLayer[256];
    private final DataLayer[] drainageLayer = new DataLayer[256];
    private final int[] seaLevelOffsetMap = new int[256];
    private final int[] chunkHeightMap = new int[256];
    private final MapGenBase caveGen;
    private final MapGenBase surfaceRavineGen;
    private final MapGenBase ravineGen;
    private final MapGenBase riverRavineGen;
    private final int seaLevel = 32;
    private final int yOffset = 112;
    private final float rainfallSpread;
    private final float floraDensitySpread;
    private final float floraDiversitySpread;
    private int[] rockLayer1 = new int[256];
    private int[] rockLayer2 = new int[256];
    private int[] rockLayer3 = new int[256];
    private float rainfall;
    private float averageTemp;

    public ChunkGenTFC(World w, String settingsString) {
        this.world = w;
        this.seed = this.world.func_72905_C();
        this.rand = new Random(this.seed);
        this.s = WorldGenSettings.fromString(settingsString).build();
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 2);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 1);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.rocksGenLayer1 = GenLayerTFC.initializeRock(this.seed + 1L, RockCategory.Layer.TOP, this.s.rockLayerSize);
        this.rocksGenLayer2 = GenLayerTFC.initializeRock(this.seed + 2L, RockCategory.Layer.MIDDLE, this.s.rockLayerSize);
        this.rocksGenLayer3 = GenLayerTFC.initializeRock(this.seed + 3L, RockCategory.Layer.BOTTOM, this.s.rockLayerSize);
        this.noiseGen7 = new NoiseGeneratorPerlin(new Random(this.seed + 4L), 4);
        this.noiseGen8 = new NoiseGeneratorPerlin(new Random(this.seed + 5L), 4);
        this.noiseGen9 = new NoiseGeneratorPerlin(new Random(this.seed + 6L), 4);
        this.noiseGen10 = new NoiseGeneratorPerlin(new Random(this.seed + 7L), 4);
        this.stabilityGenLayer = GenLayerTFC.initializeStability(this.seed + 9L);
        this.phGenLayer = GenPHLayer.initializePH(this.seed + 10L);
        this.drainageGenLayer = GenDrainageLayer.initialize(this.seed + 11L);
        this.caveGen = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCavesTFC(this.stabilityLayer), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.surfaceRavineGen = new MapGenRavineTFC(this.s.surfaceRavineRarity, this.s.surfaceRavineHeight, this.s.surfaceRavineVariability);
        this.ravineGen = new MapGenRavineTFC(this.s.ravineRarity, this.s.ravineHeight, this.s.ravineVariability);
        this.riverRavineGen = new MapGenRiverRavine(this.s.riverRavineRarity);
        this.rainfallSpread = (float)ConfigTFC.General.WORLD.rainfallSpreadFactor;
        this.floraDiversitySpread = (float)ConfigTFC.General.WORLD.floraDiversitySpreadFactor;
        this.floraDensitySpread = (float)ConfigTFC.General.WORLD.floraDensitySpreadFactor;
        this.world.func_181544_b(144);
        WorldEntitySpawnerTFC.init();
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        Chunk chunk;
        ChunkDataTFC chunkData;
        Arrays.fill(this.noise1, 0.0);
        Arrays.fill(this.noise2, 0.0);
        Arrays.fill(this.noise3, 0.0);
        Arrays.fill(this.noise4, 0.0);
        Arrays.fill(this.noise5, 0.0);
        Arrays.fill(this.noise6, 0.0);
        Arrays.fill(this.seaLevelOffsetMap, 0);
        Arrays.fill(this.chunkHeightMap, 0);
        Arrays.fill(this.heightMap, 0.0);
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkPrimerIn = new ChunkPrimer();
        this.generateRoughTerrain(chunkX, chunkZ, chunkPrimerIn);
        this.world.func_72959_q().func_76933_b(this.biomes, chunkX * 16 - 1, chunkZ * 16 - 1, 18, 18);
        this.loadLayerGeneratorData(this.stabilityGenLayer, this.stabilityLayer, chunkX * 16, chunkZ * 16, 16, 16);
        this.loadLayerGeneratorData(this.drainageGenLayer, this.drainageLayer, chunkX * 16, chunkZ * 16, 16, 16);
        this.rainfall = MathHelper.func_76131_a((float)(250.0f + 250.0f * this.rainfallSpread * (float)this.noiseGen7.func_151601_a((double)chunkX * 0.005, (double)chunkZ * 0.005)), (float)0.0f, (float)500.0f);
        float floraDiversity = MathHelper.func_76131_a((float)(0.5f + 0.5f * this.floraDiversitySpread * (float)this.noiseGen9.func_151601_a((double)chunkX * 0.005, (double)chunkZ * 0.005)), (float)0.0f, (float)1.0f);
        float floraDensity = MathHelper.func_76131_a((float)(0.3f + 0.2f * this.rainfall / 500.0f + 0.4f * this.floraDensitySpread * (float)this.noiseGen8.func_151601_a((double)chunkX * 0.05, (double)chunkZ * 0.05)), (float)0.0f, (float)1.0f);
        this.rockLayer1 = (int[])this.rocksGenLayer1.func_75904_a(chunkX * 16, chunkZ * 16, 16, 16).clone();
        this.rockLayer2 = (int[])this.rocksGenLayer2.func_75904_a(chunkX * 16, chunkZ * 16, 16, 16).clone();
        this.rockLayer3 = (int[])this.rocksGenLayer3.func_75904_a(chunkX * 16, chunkZ * 16, 16, 16).clone();
        float regionalFactor = 0.45000002f * (float)this.noiseGen10.func_151601_a((double)chunkX * 0.05, (double)chunkZ * 0.05);
        this.averageTemp = ClimateHelper.monthFactor(regionalFactor, Month.AVERAGE_TEMPERATURE_MODIFIER, chunkZ << 4);
        CustomChunkPrimer chunkPrimerOut = new CustomChunkPrimer();
        this.replaceBlocksForBiomeHigh(chunkX, chunkZ, chunkPrimerIn, chunkPrimerOut);
        if (this.caveGen instanceof MapGenCavesTFC) {
            ((MapGenCavesTFC)this.caveGen).setGenerationData(this.rainfall, (int[])this.rockLayer1.clone());
        }
        this.caveGen.func_186125_a(this.world, chunkX, chunkZ, (ChunkPrimer)chunkPrimerOut);
        this.surfaceRavineGen.func_186125_a(this.world, chunkX, chunkZ, (ChunkPrimer)chunkPrimerOut);
        this.ravineGen.func_186125_a(this.world, chunkX, chunkZ, (ChunkPrimer)chunkPrimerOut);
        this.riverRavineGen.func_186125_a(this.world, chunkX, chunkZ, (ChunkPrimer)chunkPrimerOut);
        if (ConfigTFC.General.DEBUG.debugWorldGenDanger) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    chunkPrimerOut.func_177855_a(x, 240, z, Blocks.field_150399_cn.func_176203_a(Biome.func_185362_a((Biome)this.getBiomeOffset(x, z)) & 0xF));
                    chunkPrimerOut.func_177855_a(x, 230, z, Blocks.field_150399_cn.func_176203_a(this.rockLayer1[z << 4 | x] & 0xF));
                    chunkPrimerOut.func_177855_a(x, 220, z, Blocks.field_150399_cn.func_176203_a(this.rockLayer2[z << 4 | x] & 0xF));
                    chunkPrimerOut.func_177855_a(x, 210, z, Blocks.field_150399_cn.func_176203_a(this.rockLayer3[z << 4 | x] & 0xF));
                    chunkPrimerOut.func_177855_a(x, 252, z, Blocks.field_150399_cn.func_176203_a(this.stabilityLayer[x << 4 | z].layerID & 0xF));
                    chunkPrimerOut.func_177855_a(x, 250, z, Blocks.field_150399_cn.func_176203_a(this.drainageLayer[x << 4 | z].layerID & 0xF));
                }
            }
        }
        if ((chunkData = (ChunkDataTFC)(chunk = new Chunk(this.world, (ChunkPrimer)chunkPrimerOut, chunkX, chunkZ)).getCapability(ChunkDataProvider.CHUNK_DATA_CAPABILITY, null)) == null) {
            throw new IllegalStateException("ChunkData capability is missing.");
        }
        chunkData.setGenerationData(this.rockLayer1, this.rockLayer2, this.rockLayer3, this.stabilityLayer, this.drainageLayer, this.seaLevelOffsetMap, this.rainfall, regionalFactor, this.averageTemp, floraDensity, floraDiversity);
        byte[] biomeIds = chunk.func_76605_m();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                biomeIds[z << 4 | x] = (byte)Biome.func_185362_a((Biome)this.getBiomeOffset(x, z));
            }
        }
        chunk.func_177420_a(this.chunkHeightMap);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = true;
        int worldX = chunkX << 4;
        int worldZ = chunkZ << 4;
        BlockPos blockpos = new BlockPos(worldX, 0, worldZ);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        this.rand.setSeed((long)chunkX * (this.rand.nextLong() / 2L * 2L + 1L) + (long)chunkZ * (this.rand.nextLong() / 2L * 2L + 1L) ^ this.world.func_72905_C());
        SOIL_PITS_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        ORE_VEINS_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        LAVA_FISSURE_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        WATER_FISSURE_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        LARGE_ROCKS_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        TREE_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        BERRY_BUSH_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        FRUIT_TREE_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        biome.func_180624_a(this.world, this.rand, blockpos);
        LOOSE_ROCKS_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        WATERFALL_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        LAVAFALL_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        STALACTITE_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        STALAGMITE_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        SNOW_ICE_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawnerTFC.performWorldGenSpawning(this.world, biome, worldX + 8, worldZ + 8, 16, 16, this.rand);
        }
        WILD_CROPS_GEN.generate(this.rand, chunkX, chunkZ, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    private void loadLayerGeneratorData(GenLayerTFC gen, DataLayer[] layers, int x, int y, int width, int height) {
        IntCache.func_76446_a();
        int[] ints = gen.func_75904_a(x, y, width, height);
        for (int i = 0; i < width * height; ++i) {
            layers[i] = DataLayer.get(ints[i]);
        }
    }

    private void generateRoughTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.world.func_72959_q().func_76937_a(this.biomes, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.generateHeightMap(chunkX * 4, chunkZ * 4);
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                for (int y = 0; y < 16; ++y) {
                    double noiseDL = this.heightMap[((x + 0) * 5 + z + 0) * 17 + y];
                    double noiseUL = this.heightMap[((x + 0) * 5 + z + 1) * 17 + y];
                    double noiseDR = this.heightMap[((x + 1) * 5 + z + 0) * 17 + y];
                    double noiseUR = this.heightMap[((x + 1) * 5 + z + 1) * 17 + y];
                    double noiseDLA = (this.heightMap[((x + 0) * 5 + z + 0) * 17 + y + 1] - noiseDL) * 0.125;
                    double noiseULA = (this.heightMap[((x + 0) * 5 + z + 1) * 17 + y + 1] - noiseUL) * 0.125;
                    double noiseDRA = (this.heightMap[((x + 1) * 5 + z + 0) * 17 + y + 1] - noiseDR) * 0.125;
                    double noiseURA = (this.heightMap[((x + 1) * 5 + z + 1) * 17 + y + 1] - noiseUR) * 0.125;
                    for (int yy = 0; yy < 8; ++yy) {
                        double var34 = noiseDL;
                        double var36 = noiseUL;
                        double var38 = (noiseDR - noiseDL) * 0.25;
                        double var40 = (noiseUR - noiseUL) * 0.25;
                        for (int xx = 0; xx < 4; ++xx) {
                            double var49 = (var36 - var34) * 0.25;
                            double var47 = var34 - var49;
                            for (int zz = 0; zz < 4; ++zz) {
                                double d;
                                var47 += var49;
                                if (d > 0.0) {
                                    primer.func_177855_a(x * 4 + xx, y * 8 + yy, z * 4 + zz, STONE);
                                    continue;
                                }
                                if (y * 8 + yy < 32) {
                                    primer.func_177855_a(x * 4 + xx, y * 8 + yy, z * 4 + zz, SALT_WATER);
                                    continue;
                                }
                                primer.func_177855_a(x * 4 + xx, y * 8 + yy, z * 4 + zz, AIR);
                            }
                            var34 += var38;
                            var36 += var40;
                        }
                        noiseDL += noiseDLA;
                        noiseUL += noiseULA;
                        noiseDR += noiseDRA;
                        noiseUR += noiseURA;
                    }
                }
            }
        }
    }

    private void generateHeightMap(int xPos, int zPos) {
        this.noiseGen6.func_76305_a(this.noise6, xPos, zPos, 5, 5, 200.0, 200.0, 0.5);
        this.noiseGen3.func_76304_a(this.noise3, xPos, 0, zPos, 5, 17, 5, 12.5, 6.25, 12.5);
        this.noiseGen1.func_76304_a(this.noise1, xPos, 0, zPos, 5, 17, 5, 1000.0, 1000.0, 1000.0);
        this.noiseGen2.func_76304_a(this.noise2, xPos, 0, zPos, 5, 17, 5, 1000.0, 1000.0, 1000.0);
        int i = 0;
        int j = 0;
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                float variationBlended = 0.0f;
                float rootBlended = 0.0f;
                float totalBlendedHeight = 0.0f;
                Biome baseBiome = this.biomes[x + 2 + (z + 2) * 10];
                for (int xR = -2; xR <= 2; ++xR) {
                    for (int zR = -2; zR <= 2; ++zR) {
                        Biome blendBiome = this.biomes[x + xR + 2 + (z + zR + 2) * 10];
                        float blendedHeight = parabolicField[xR + 2 + (zR + 2) * 5] / 2.0f;
                        if (blendBiome.func_185355_j() > baseBiome.func_185355_j()) {
                            blendedHeight *= 0.5f;
                        }
                        variationBlended += blendBiome.func_185360_m() * blendedHeight;
                        rootBlended += blendBiome.func_185355_j() * blendedHeight;
                        totalBlendedHeight += blendedHeight;
                    }
                }
                variationBlended /= totalBlendedHeight;
                rootBlended /= totalBlendedHeight;
                variationBlended = variationBlended * 0.9f + 0.1f;
                rootBlended = (rootBlended * 4.0f - 1.0f) / 8.0f;
                int n = j++;
                double scaledNoise6Value = this.noise6[n] / 8000.0;
                if (scaledNoise6Value < 0.0) {
                    scaledNoise6Value = -scaledNoise6Value * 0.3;
                }
                if ((scaledNoise6Value = scaledNoise6Value * 3.0 - 2.0) < 0.0) {
                    if ((scaledNoise6Value /= 2.0) < -1.0) {
                        scaledNoise6Value = -1.0;
                    }
                    scaledNoise6Value /= 2.8;
                } else {
                    if (scaledNoise6Value > 1.0) {
                        scaledNoise6Value = 1.0;
                    }
                    scaledNoise6Value /= 8.0;
                }
                for (int y = 0; y < 17; ++y) {
                    double rootBlendedCopy = rootBlended;
                    rootBlendedCopy += scaledNoise6Value * 0.2;
                    double var28 = 8.5 + (rootBlendedCopy = rootBlendedCopy * 17.0 / 16.0) * 4.0;
                    double var32 = ((double)y - var28) * 12.0 * 256.0 / 256.0 / (2.7 + (double)variationBlended);
                    if (var32 < 0.0) {
                        var32 *= 4.0;
                    }
                    double var34 = this.noise1[i] / 512.0;
                    double var36 = this.noise2[i] / 512.0;
                    double var38 = (this.noise3[i] / 10.0 + 1.0) / 2.0;
                    double output = var38 < 0.0 ? var34 : (var38 > 1.0 ? var36 : var34 + (var36 - var34) * var38);
                    output -= var32;
                    if (y > 13) {
                        double var40 = (float)(y - 13) / 3.0f;
                        output = output * (1.0 - var40) + -10.0 * var40;
                    }
                    this.heightMap[i++] = output;
                }
            }
        }
    }

    private Biome getBiomeOffset(int x, int z) {
        return this.biomes[(z + 1) * 18 + (x + 1)];
    }

    private void replaceBlocksForBiomeHigh(int chunkX, int chunkZ, ChunkPrimer inp, CustomChunkPrimer outp) {
        double var6 = 0.03125;
        this.noiseGen4.func_76304_a(this.noise4, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, var6 * 4.0, var6, var6 * 4.0);
        boolean[] cliffMap = new boolean[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int colIndex = z << 4 | x;
                Biome biome = this.getBiomeOffset(x, z);
                Rock rock1 = (Rock)((ForgeRegistry)TFCRegistries.ROCKS).getValue(this.rockLayer1[colIndex]);
                Rock rock2 = (Rock)((ForgeRegistry)TFCRegistries.ROCKS).getValue(this.rockLayer2[colIndex]);
                Rock rock3 = (Rock)((ForgeRegistry)TFCRegistries.ROCKS).getValue(this.rockLayer3[colIndex]);
                DataLayer drainage = this.drainageLayer[colIndex];
                DataLayer stability = this.stabilityLayer[colIndex];
                int noise = (int)(this.noise4[colIndex] / 3.0 + 6.0);
                int smooth = -1;
                IBlockState surfaceBlock = BlockRockVariant.get(rock1, (double)this.rainfall + 1.3 * this.rand.nextGaussian() >= 150.0 ? Rock.Type.GRASS : Rock.Type.DRY_GRASS).func_176223_P();
                IBlockState subSurfaceBlock = BlockRockVariant.get(rock1, Rock.Type.DIRT).func_176223_P();
                if ((BiomesTFC.isBeachBiome(this.getBiomeOffset(x - 1, z)) || BiomesTFC.isBeachBiome(this.getBiomeOffset(x + 1, z)) || BiomesTFC.isBeachBiome(this.getBiomeOffset(x, z + 1)) || BiomesTFC.isBeachBiome(this.getBiomeOffset(x, z - 1))) && !BiomesTFC.isBeachBiome(this.getBiomeOffset(x, z))) {
                    cliffMap[colIndex] = true;
                }
                int nonRiverTiles = 0;
                int nonBeachTiles = 0;
                for (int a = x - 1; a <= x + 1; ++a) {
                    for (int b = z - 1; b <= z + 1; ++b) {
                        Biome BiomeAtOffset = this.getBiomeOffset(a, b);
                        if (!BiomesTFC.isRiverBiome(BiomeAtOffset)) {
                            ++nonRiverTiles;
                        }
                        if (BiomesTFC.isBeachBiome(BiomeAtOffset) || BiomesTFC.isOceanicBiome(BiomeAtOffset) || BiomeAtOffset == BiomesTFC.DEEP_OCEAN || BiomeAtOffset == BiomesTFC.OCEAN) continue;
                        ++nonBeachTiles;
                    }
                }
                int highestStone = 0;
                for (y = 143; y >= 0; --y) {
                    int beachCliffHeight;
                    if (outp.isEmpty(x, y + 112, z)) {
                        outp.func_177855_a(x, y + 112, z, inp.func_177856_a(x, y, z));
                        if (y + 1 < 112 && outp.func_177856_a(x, y + 112, z) == AIR) {
                            int upCount = 1;
                            while (BlocksTFC.isSoilOrGravel(outp.func_177856_a(x, y + 112 + upCount, z))) {
                                outp.func_177855_a(x, y + 112 + upCount, z, AIR);
                                ++upCount;
                            }
                        }
                    }
                    if (outp.func_177856_a(x, y + 112, z) == STONE) {
                        highestStone = Math.max(highestStone, y);
                    }
                    int highestBeachTheoretical = (highestStone - 32) / 4 + 32;
                    int n = beachCliffHeight = nonBeachTiles > 0 ? (int)((double)((highestStone - highestBeachTheoretical) * nonBeachTiles) / 6.0 + (double)highestBeachTheoretical) : highestBeachTheoretical;
                    if (BiomesTFC.isBeachBiome(biome) && y > 32 && outp.func_177856_a(x, y + 112, z) != AIR && y >= beachCliffHeight) {
                        inp.func_177855_a(x, y, z, AIR);
                        outp.func_177855_a(x, y + 112, z, AIR);
                    }
                    if (BiomesTFC.isRiverBiome(biome) && y >= 30 && outp.func_177856_a(x, y + 112, z) != AIR) {
                        if (nonRiverTiles > 0) {
                            if (y >= 31) {
                                inp.func_177855_a(x, y, z, y >= 32 ? AIR : SALT_WATER);
                                outp.func_177855_a(x, y + 112, z, y >= 32 ? AIR : SALT_WATER);
                            }
                        } else {
                            inp.func_177855_a(x, y, z, y >= 32 ? AIR : SALT_WATER);
                            outp.func_177855_a(x, y + 112, z, y >= 32 ? AIR : SALT_WATER);
                        }
                    } else if (!BiomesTFC.isRiverBiome(biome) && nonRiverTiles < 9 && outp.func_177856_a(x, y + 112, z) == STONE && (y >= (highestStone - 32) / (10 - nonRiverTiles) + 32 || nonRiverTiles <= 5 && y >= 32)) {
                        inp.func_177855_a(x, y, z, y >= 32 ? AIR : SALT_WATER);
                        outp.func_177855_a(x, y + 112, z, y >= 32 ? AIR : SALT_WATER);
                    }
                    if (outp.func_177856_a(x, y + 112, z) == STONE) {
                        if (this.seaLevelOffsetMap[colIndex] == 0 && y - 32 >= 0) {
                            this.seaLevelOffsetMap[colIndex] = y - 32;
                        }
                        if (this.chunkHeightMap[colIndex] == 0) {
                            this.chunkHeightMap[colIndex] = y + 112;
                        }
                        if (y + 112 <= 55 + this.seaLevelOffsetMap[colIndex]) {
                            outp.func_177855_a(x, y + 112, z, BlockRockVariant.get(rock3, Rock.Type.RAW).func_176223_P());
                        } else if (y + 112 <= 110 + this.seaLevelOffsetMap[colIndex]) {
                            outp.func_177855_a(x, y + 112, z, BlockRockVariant.get(rock2, Rock.Type.RAW).func_176223_P());
                        } else {
                            outp.func_177855_a(x, y + 112, z, BlockRockVariant.get(rock1, Rock.Type.RAW).func_176223_P());
                        }
                        if ((double)this.rainfall < 1.3 * this.rand.nextGaussian() + 75.0) {
                            subSurfaceBlock = surfaceBlock = BlockRockVariant.get(rock1, Rock.Type.RAW).getVariant(Rock.Type.SAND).func_176223_P();
                        }
                        if (biome == BiomesTFC.BEACH || biome == BiomesTFC.OCEAN || biome == BiomesTFC.DEEP_OCEAN) {
                            subSurfaceBlock = surfaceBlock = BlockRockVariant.get(rock1, Rock.Type.SAND).func_176223_P();
                        } else if (biome == BiomesTFC.GRAVEL_BEACH) {
                            subSurfaceBlock = surfaceBlock = BlockRockVariant.get(rock1, Rock.Type.GRAVEL).func_176223_P();
                        }
                        if (smooth == -1) {
                            int arrayIndexx = x > 0 ? x - 1 + z * 16 : -1;
                            int arrayIndexX = x < 15 ? x + 1 + z * 16 : -1;
                            int arrayIndexz = z > 0 ? x + (z - 1) * 16 : -1;
                            int arrayIndexZ = z < 15 ? x + (z + 1) * 16 : -1;
                            for (int counter = 1; counter < noise / 3; ++counter) {
                                if (arrayIndexx < 0 || this.seaLevelOffsetMap[colIndex] - 3 * counter <= this.seaLevelOffsetMap[arrayIndexx] || arrayIndexX < 0 || this.seaLevelOffsetMap[colIndex] - 3 * counter <= this.seaLevelOffsetMap[arrayIndexX] || arrayIndexz < 0 || this.seaLevelOffsetMap[colIndex] - 3 * counter <= this.seaLevelOffsetMap[arrayIndexz] || arrayIndexZ < 0 || this.seaLevelOffsetMap[colIndex] - 3 * counter <= this.seaLevelOffsetMap[arrayIndexZ]) continue;
                                int n2 = colIndex;
                                this.seaLevelOffsetMap[n2] = this.seaLevelOffsetMap[n2] - 1;
                                --noise;
                                --y;
                            }
                            smooth = (int)((double)noise * (1.0 - Math.max(Math.min((double)(y - 16) / 80.0, 1.0), 0.0)));
                            for (int c = 1; c < 3; ++c) {
                                IBlockState current;
                                if (112 + y + c > 256 || (current = outp.func_177856_a(x, 112 + y + c, z)) == surfaceBlock || current == subSurfaceBlock || BlocksTFC.isWater(current)) continue;
                                outp.func_177855_a(x, 112 + y + c, z, AIR);
                                if (112 + y + c + 1 > 256 || outp.func_177856_a(x, 112 + y + c + 1, z) != SALT_WATER) continue;
                                outp.func_177855_a(x, 112 + y + c, z, subSurfaceBlock);
                            }
                            int dirtH = Math.max(8 - (y + 112 - 24 - 144) / 16, 0);
                            if (!(smooth <= 0 || y < 31 || y + 1 >= 112 || inp.func_177856_a(x, y + 1, z) == SALT_WATER || dirtH <= 0 || BiomesTFC.isBeachBiome(biome) && y > highestBeachTheoretical + 2)) {
                                outp.func_177855_a(x, y + 112, z, surfaceBlock);
                                boolean mountains = BiomesTFC.isMountainBiome(biome) || biome == BiomesTFC.HIGH_HILLS || biome == BiomesTFC.HIGH_HILLS_EDGE || biome == BiomesTFC.MOUNTAINS || biome == BiomesTFC.MOUNTAINS_EDGE;
                                for (int c = 1; c < dirtH && !mountains && !cliffMap[colIndex]; ++c) {
                                    outp.func_177855_a(x, y - c + 112, z, subSurfaceBlock);
                                    if (c <= 1 + (5 - drainage.valueInt)) continue;
                                    outp.func_177855_a(x, y - c + 112, z, BlockRockVariant.get(rock1, Rock.Type.GRAVEL).func_176223_P());
                                }
                            }
                        }
                        if ((y <= 30 || y >= 32 || inp.func_177856_a(x, y + 1, z) != SALT_WATER) && (y >= 32 || inp.func_177856_a(x, y + 1, z) != SALT_WATER)) continue;
                        if (biome != BiomesTFC.SWAMPLAND) {
                            if (outp.func_177856_a(x, y + 112, z) == BlockRockVariant.get(rock1, Rock.Type.SAND).func_176223_P() || this.rand.nextInt(5) == 0) continue;
                            outp.func_177855_a(x, y + 112, z, BlockRockVariant.get(rock1, Rock.Type.GRAVEL).func_176223_P());
                            continue;
                        }
                        if (outp.func_177856_a(x, y + 112, z) == BlockRockVariant.get(rock1, Rock.Type.SAND).func_176223_P()) continue;
                        outp.func_177855_a(x, y + 112, z, BlockRockVariant.get(rock1, Rock.Type.DIRT).func_176223_P());
                        continue;
                    }
                    if (inp.func_177856_a(x, y, z) != SALT_WATER || BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome)) continue;
                    outp.func_177855_a(x, y + 112, z, FRESH_WATER);
                }
                for (y = 111; y >= 0; --y) {
                    if (y < 1 + (this.s.flatBedrock ? 0 : this.rand.nextInt(3))) {
                        outp.func_177855_a(x, y, z, BEDROCK);
                    } else if (outp.isEmpty(x, y, z)) {
                        if (y <= 55 + this.seaLevelOffsetMap[colIndex]) {
                            outp.func_177855_a(x, y, z, BlockRockVariant.get(rock3, Rock.Type.RAW).func_176223_P());
                        } else if (y <= 110 + this.seaLevelOffsetMap[colIndex]) {
                            outp.func_177855_a(x, y, z, BlockRockVariant.get(rock2, Rock.Type.RAW).func_176223_P());
                        } else {
                            outp.func_177855_a(x, y, z, BlockRockVariant.get(rock1, Rock.Type.RAW).func_176223_P());
                        }
                        if ((BiomesTFC.isBeachBiome(biome) || BiomesTFC.isOceanicBiome(biome)) && outp.func_177856_a(x, y + 1, z) == SALT_WATER) {
                            outp.func_177855_a(x, y, z, BlockRockVariant.get(rock1, Rock.Type.SAND).func_176223_P());
                            outp.func_177855_a(x, y - 1, z, BlockRockVariant.get(rock1, Rock.Type.SAND).func_176223_P());
                        }
                    }
                    if (y > 6 || stability.valueInt != 1 || outp.func_177856_a(x, y, z) != AIR) continue;
                    outp.func_177855_a(x, y, z, LAVA);
                    if (outp.func_177856_a(x, y + 1, z) == LAVA || !this.rand.nextBoolean()) continue;
                    outp.func_177855_a(x, y + 1, z, LAVA);
                }
            }
        }
    }

    static {
        for (int x2 = -2; x2 <= 2; ++x2) {
            for (int y = -2; y <= 2; ++y) {
                ChunkGenTFC.parabolicField[x2 + 2 + (y + 2) * 5] = 10.0f / MathHelper.func_76129_c((float)((float)(x2 * x2 + y * y) + 0.2f));
            }
        }
    }
}

