/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.biomes;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.worldgen.WorldGenPlantTFC;
import net.dries007.tfc.world.classic.worldgen.WorldGenSandTFC;
import net.dries007.tfc.world.classic.worldgen.WorldGenWildCrops;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

@ParametersAreNonnullByDefault
public class BiomeDecoratorTFC
extends BiomeDecorator {
    private final int lilyPadPerChunk;
    private final int waterPlantsPerChunk;
    private final WorldGenWildCrops wildCropsGen;
    private final WorldGenPlantTFC plantGen;
    private int standardCount = 0;
    private int tallCount = 0;
    private int creepingCount = 0;
    private int hangingCount = 0;
    private int floatingCount = 0;
    private int floatingSeaCount = 0;
    private int desertCount = 0;
    private int dryCount = 0;
    private int cactusCount = 0;
    private int grassCount = 0;
    private int tallGrassCount = 0;
    private int epiphyteCount = 0;
    private int reedCount = 0;
    private int reedSeaCount = 0;
    private int waterCount = 0;
    private int waterSeaCount = 0;
    private int mushroomCount = 0;

    public BiomeDecoratorTFC(int lilyPadPerChunk, int waterPlantsPerChunk) {
        this.lilyPadPerChunk = lilyPadPerChunk;
        this.waterPlantsPerChunk = waterPlantsPerChunk;
        this.field_76809_f = null;
        this.field_76810_g = null;
        this.field_76822_h = null;
        this.field_150514_p = null;
        this.field_76828_s = null;
        this.field_76827_t = null;
        this.field_76826_u = null;
        this.plantGen = new WorldGenPlantTFC();
        this.field_76810_g = new WorldGenSandTFC(7);
        this.wildCropsGen = new WorldGenWildCrops();
        block18: for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
            switch (plant.getPlantType()) {
                case TALL_PLANT: {
                    ++this.tallCount;
                    continue block18;
                }
                case CREEPING: {
                    ++this.creepingCount;
                    continue block18;
                }
                case HANGING: {
                    ++this.hangingCount;
                    continue block18;
                }
                case FLOATING: {
                    ++this.floatingCount;
                    continue block18;
                }
                case FLOATING_SEA: {
                    ++this.floatingSeaCount;
                    continue block18;
                }
                case DESERT: 
                case DESERT_TALL_PLANT: {
                    ++this.desertCount;
                    continue block18;
                }
                case DRY: 
                case DRY_TALL_PLANT: {
                    ++this.dryCount;
                    continue block18;
                }
                case CACTUS: {
                    ++this.cactusCount;
                    continue block18;
                }
                case SHORT_GRASS: {
                    ++this.grassCount;
                    continue block18;
                }
                case TALL_GRASS: {
                    ++this.tallGrassCount;
                    continue block18;
                }
                case EPIPHYTE: {
                    ++this.epiphyteCount;
                    continue block18;
                }
                case REED: 
                case TALL_REED: {
                    ++this.reedCount;
                    continue block18;
                }
                case REED_SEA: 
                case TALL_REED_SEA: {
                    ++this.reedSeaCount;
                    continue block18;
                }
                case WATER: 
                case TALL_WATER: 
                case EMERGENT_TALL_WATER: {
                    ++this.waterCount;
                    continue block18;
                }
                case WATER_SEA: 
                case TALL_WATER_SEA: 
                case EMERGENT_TALL_WATER_SEA: {
                    ++this.waterSeaCount;
                    continue block18;
                }
                case MUSHROOM: {
                    ++this.mushroomCount;
                    continue block18;
                }
            }
            ++this.standardCount;
        }
    }

    public void func_180292_a(World world, Random rng, Biome biome, BlockPos chunkPos) {
        BlockPos blockPos;
        ChunkPos forgeChunkPos = new ChunkPos(chunkPos);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world, rng, forgeChunkPos));
        ChunkDataTFC data = ChunkDataTFC.get(world, chunkPos);
        if (!data.isInitialized()) {
            return;
        }
        float avgTemperature = ClimateTFC.getAvgTemp(world, chunkPos);
        float rainfall = ChunkDataTFC.getRainfall(world, chunkPos);
        float floraDensity = data.getFloraDensity();
        float floraDiversity = data.getFloraDiversity();
        this.field_180294_c = chunkPos;
        if (TerrainGen.decorate((World)world, (Random)rng, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                if (plant.getPlantType() != Plant.PlantType.MUSHROOM || !plant.isValidTempForWorldGen(avgTemperature) || !plant.isValidRain(rainfall)) continue;
                this.plantGen.setGeneratedPlant(plant);
                for (float i = (float)rng.nextInt(Math.round((float)this.mushroomCount / floraDiversity)); i < (1.0f + floraDensity) * 5.0f; i += 1.0f) {
                    blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                    this.plantGen.func_180709_b(world, rng, blockPos);
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rng, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                if (plant.getPlantType() != Plant.PlantType.CACTUS || !plant.isValidTempForWorldGen(avgTemperature) || !plant.isValidRain(rainfall)) continue;
                this.plantGen.setGeneratedPlant(plant);
                int i = rng.nextInt(Math.round((float)(this.cactusCount + 32) / floraDiversity));
                while ((float)i < (1.0f + floraDensity) * 3.0f) {
                    blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                    this.plantGen.func_180709_b(world, rng, blockPos);
                    ++i;
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rng, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LILYPAD)) {
            block29: for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                if (!plant.isValidTempForWorldGen(avgTemperature) || !plant.isValidRain(rainfall)) continue;
                this.plantGen.setGeneratedPlant(plant);
                switch (plant.getPlantType()) {
                    case FLOATING: {
                        int i = rng.nextInt(Math.round((float)this.floatingCount / floraDiversity));
                        while ((float)i < floraDensity * (float)this.lilyPadPerChunk) {
                            blockPos = world.func_175725_q(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                            ++i;
                        }
                        continue block29;
                    }
                    case FLOATING_SEA: {
                        int i = rng.nextInt(Math.round((float)(this.floatingSeaCount + 64) / floraDiversity));
                        while ((float)i < floraDensity * (float)this.lilyPadPerChunk) {
                            blockPos = world.func_175725_q(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                            ++i;
                        }
                        break;
                    }
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rng, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED)) {
            block32: for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                if (!plant.isValidTempForWorldGen(avgTemperature) || !plant.isValidRain(rainfall)) continue;
                this.plantGen.setGeneratedPlant(plant);
                switch (plant.getPlantType()) {
                    case REED: 
                    case TALL_REED: {
                        int i = rng.nextInt(Math.round((float)this.reedCount / floraDiversity));
                        while ((float)i < (1.0f + floraDensity) * 5.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                            ++i;
                        }
                        continue block32;
                    }
                    case REED_SEA: 
                    case TALL_REED_SEA: {
                        int i = rng.nextInt(Math.round((float)this.reedSeaCount / floraDiversity));
                        while ((float)i < (1.0f + floraDensity) * 5.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                            ++i;
                        }
                        break;
                    }
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rng, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            block35: for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                if (!plant.isValidTempForWorldGen(avgTemperature) || !plant.isValidRain(rainfall)) continue;
                this.plantGen.setGeneratedPlant(plant);
                switch (plant.getPlantType()) {
                    case WATER: 
                    case TALL_WATER: 
                    case EMERGENT_TALL_WATER: {
                        int i = rng.nextInt(Math.round((float)this.waterCount / floraDiversity));
                        while ((float)i < floraDensity * (float)this.waterPlantsPerChunk) {
                            blockPos = world.func_175725_q(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                            ++i;
                        }
                        continue block35;
                    }
                    case WATER_SEA: 
                    case TALL_WATER_SEA: 
                    case EMERGENT_TALL_WATER_SEA: {
                        int i = rng.nextInt(Math.round((float)this.waterSeaCount / floraDiversity));
                        while ((float)i < floraDensity * (float)this.waterPlantsPerChunk) {
                            blockPos = world.func_175725_q(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                            ++i;
                        }
                        continue block35;
                    }
                    case EPIPHYTE: {
                        for (float i = (float)rng.nextInt(Math.round((float)this.epiphyteCount / floraDiversity)); i < (1.0f + floraDensity) * 5.0f; i += 1.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                        }
                        continue block35;
                    }
                    case CREEPING: {
                        for (float i = (float)rng.nextInt(Math.round((float)(this.creepingCount + 32) / floraDiversity)); i < (1.0f + floraDensity) * 5.0f; i += 1.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                        }
                        continue block35;
                    }
                    case HANGING: {
                        for (float i = (float)rng.nextInt(Math.round((float)this.hangingCount / floraDiversity)); i < (1.0f + floraDensity) * 5.0f; i += 1.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                        }
                        continue block35;
                    }
                    case TALL_PLANT: {
                        for (float i = (float)rng.nextInt(Math.round((float)(this.tallCount + 8) / floraDiversity)); i < (1.0f + floraDensity) * 3.0f; i += 1.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                        }
                        continue block35;
                    }
                    case STANDARD: {
                        for (float i = (float)rng.nextInt(Math.round((float)(this.standardCount + 32) / floraDiversity)); i < (1.0f + floraDensity) * 3.0f; i += 1.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                        }
                        break;
                    }
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rng, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH)) {
            block43: for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                if (!plant.isValidTempForWorldGen(avgTemperature) || !plant.isValidRain(rainfall)) continue;
                this.plantGen.setGeneratedPlant(plant);
                switch (plant.getPlantType()) {
                    case DESERT: 
                    case DESERT_TALL_PLANT: {
                        float i;
                        for (i = (float)rng.nextInt(Math.round((float)(this.desertCount + 16) / floraDiversity)); i < (1.0f + floraDensity) * 5.0f; i += 1.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                        }
                        continue block43;
                    }
                    case DRY: 
                    case DRY_TALL_PLANT: {
                        float i;
                        for (i = (float)rng.nextInt(Math.round((float)(this.dryCount + 16) / floraDiversity)); i < (1.0f + floraDensity) * 5.0f; i += 1.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                        }
                        break;
                    }
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rng, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            block46: for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                if (!plant.isValidTempForWorldGen(avgTemperature) || !plant.isValidRain(rainfall)) continue;
                this.plantGen.setGeneratedPlant(plant);
                switch (plant.getPlantType()) {
                    case SHORT_GRASS: {
                        int i = rng.nextInt(Math.round((float)this.grassCount / floraDiversity));
                        while ((float)i < (3.0f + floraDensity) * 5.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                            ++i;
                        }
                        continue block46;
                    }
                    case TALL_GRASS: {
                        int i = rng.nextInt(Math.round((float)(this.tallGrassCount + 8) / floraDiversity));
                        while ((float)i < (1.0f + floraDensity) * 5.0f) {
                            blockPos = world.func_175645_m(chunkPos.func_177982_a(rng.nextInt(16) + 8, 0, rng.nextInt(16) + 8));
                            this.plantGen.func_180709_b(world, rng, blockPos);
                            ++i;
                        }
                        break;
                    }
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world, rng, forgeChunkPos));
    }
}

