/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.chunkdata;

import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.network.PacketChunkData;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="tfc")
public final class CapabilityChunkData {
    public static final ResourceLocation CHUNK_DATA = new ResourceLocation("tfc", "chunkdata");

    public static void preInit() {
        CapabilityManager.INSTANCE.register(ChunkDataTFC.class, (Capability.IStorage)new ChunkDataTFC.ChunkDataStorage(), ChunkDataTFC::new);
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesChunk(AttachCapabilitiesEvent<Chunk> event) {
        if (((Chunk)event.getObject()).func_177412_p() != null && ((Chunk)event.getObject()).func_177412_p().func_175624_G() == TerraFirmaCraft.getWorldType()) {
            event.addCapability(CHUNK_DATA, (ICapabilityProvider)new ChunkDataProvider());
        }
    }

    @SubscribeEvent
    public static void onChunkWatchWatch(ChunkWatchEvent.Watch event) {
        ChunkDataTFC data;
        Chunk chunk = event.getChunkInstance();
        if (chunk != null && (data = (ChunkDataTFC)chunk.getCapability(ChunkDataProvider.CHUNK_DATA_CAPABILITY, null)) != null && data.isInitialized()) {
            ClimateTFC.update(chunk.func_76632_l(), data.getRegionalTemp(), data.getRainfall());
            NBTTagCompound nbt = (NBTTagCompound)ChunkDataProvider.CHUNK_DATA_CAPABILITY.writeNBT((Object)data, null);
            TerraFirmaCraft.getNetwork().sendTo((IMessage)new PacketChunkData(chunk.func_76632_l(), nbt, data.getRegionalTemp(), data.getRainfall()), event.getPlayer());
        }
    }
}

