/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.chunkdata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.util.NBTBuilder;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.world.classic.DataLayer;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.classic.worldgen.vein.Vein;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.registries.ForgeRegistry;

public final class ChunkDataTFC {
    public static final int FISH_POP_MAX = 60;
    private static final ChunkDataTFC EMPTY = new ChunkDataTFC();
    private final int[] rockLayer1 = new int[256];
    private final int[] rockLayer2 = new int[256];
    private final int[] rockLayer3 = new int[256];
    private final DataLayer[] drainageLayer = new DataLayer[256];
    private final DataLayer[] stabilityLayer = new DataLayer[256];
    private final int[] seaLevelOffset = new int[256];
    private boolean initialized = false;
    private int fishPopulation = 60;
    private float rainfall;
    private float regionalTemp;
    private float avgTemp;
    private float floraDensity;
    private float floraDiversity;
    private Set<Vein> generatedVeins = new HashSet<Vein>();
    private int chunkWorkage;
    private long protectedTicks;
    private long lastUpdateTick;
    private long lastUpdateYear;

    @Nonnull
    public static ChunkDataTFC get(World world, BlockPos pos) {
        return ChunkDataTFC.get(world.func_175726_f(pos));
    }

    @Nonnull
    public static ChunkDataTFC get(Chunk chunk) {
        ChunkDataTFC data = (ChunkDataTFC)chunk.getCapability(ChunkDataProvider.CHUNK_DATA_CAPABILITY, null);
        return data == null ? EMPTY : data;
    }

    public static Rock getRock1(World world, BlockPos pos) {
        return ChunkDataTFC.get(world, pos).getRockLayer1(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
    }

    public static Rock getRock2(World world, BlockPos pos) {
        return ChunkDataTFC.get(world, pos).getRockLayer2(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
    }

    public static Rock getRock3(World world, BlockPos pos) {
        return ChunkDataTFC.get(world, pos).getRockLayer3(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
    }

    public static float getRainfall(World world, BlockPos pos) {
        return ChunkDataTFC.get(world, pos).getRainfall();
    }

    public static float getFloraDensity(World world, BlockPos pos) {
        return ChunkDataTFC.get(world, pos).getFloraDensity();
    }

    public static float getFloraDiversity(World world, BlockPos pos) {
        return ChunkDataTFC.get(world, pos).getFloraDiversity();
    }

    public static boolean isStable(World world, BlockPos pos) {
        return ChunkDataTFC.get((World)world, (BlockPos)pos).getStabilityLayer((int)(pos.func_177958_n() & 0xF), (int)(pos.func_177952_p() & 0xF)).valueInt == 0;
    }

    public static int getDrainage(World world, BlockPos pos) {
        return ChunkDataTFC.get((World)world, (BlockPos)pos).getDrainageLayer((int)(pos.func_177958_n() & 0xF), (int)(pos.func_177952_p() & 0xF)).valueInt;
    }

    public static int getSeaLevelOffset(World world, BlockPos pos) {
        return ChunkDataTFC.get(world, pos).getSeaLevelOffset(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
    }

    public static int getFishPopulation(World world, BlockPos pos) {
        return ChunkDataTFC.get(world, pos).getFishPopulation();
    }

    public static Rock getRockHeight(World world, BlockPos pos) {
        return ChunkDataTFC.get(world, pos).getRockLayerHeight(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF);
    }

    public void setGenerationData(int[] rockLayer1, int[] rockLayer2, int[] rockLayer3, DataLayer[] stabilityLayer, DataLayer[] drainageLayer, int[] seaLevelOffset, float rainfall, float regionalTemp, float avgTemp, float floraDensity, float floraDiversity) {
        this.initialized = true;
        System.arraycopy(rockLayer1, 0, this.rockLayer1, 0, 256);
        System.arraycopy(rockLayer2, 0, this.rockLayer2, 0, 256);
        System.arraycopy(rockLayer3, 0, this.rockLayer3, 0, 256);
        System.arraycopy(stabilityLayer, 0, this.stabilityLayer, 0, 256);
        System.arraycopy(drainageLayer, 0, this.drainageLayer, 0, 256);
        System.arraycopy(seaLevelOffset, 0, this.seaLevelOffset, 0, 256);
        this.rainfall = rainfall;
        this.regionalTemp = regionalTemp;
        this.avgTemp = avgTemp;
        this.floraDensity = floraDensity;
        this.floraDiversity = floraDiversity;
        this.chunkWorkage = 0;
        this.lastUpdateTick = CalendarTFC.PLAYER_TIME.getTicks();
        this.lastUpdateYear = CalendarTFC.CALENDAR_TIME.getTotalYears();
    }

    public void markVeinGenerated(@Nonnull Vein vein) {
        this.generatedVeins.add(vein);
    }

    public Set<Vein> getGeneratedVeins() {
        return this.generatedVeins;
    }

    public boolean canWork(int amount) {
        return ConfigTFC.Devices.SLUICE.maxWorkChunk == 0 || this.chunkWorkage <= ConfigTFC.Devices.SLUICE.maxWorkChunk + amount;
    }

    public void addWork(int amount) {
        this.chunkWorkage += amount;
    }

    public void addWork() {
        this.addWork(1);
    }

    public void setWork(int amount) {
        this.chunkWorkage = amount;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Rock getRock1(BlockPos pos) {
        return this.getRock1(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF);
    }

    public Rock getRock1(int x, int z) {
        return this.getRockLayer1(x, z);
    }

    public Rock getRock2(BlockPos pos) {
        return this.getRock2(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF);
    }

    public Rock getRock2(int x, int z) {
        return this.getRockLayer2(x, z);
    }

    public Rock getRock3(BlockPos pos) {
        return this.getRock3(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF);
    }

    public Rock getRock3(int x, int z) {
        return this.getRockLayer3(x, z);
    }

    public boolean isStable(int x, int z) {
        return this.getStabilityLayer((int)x, (int)z).valueInt == 0;
    }

    public int getDrainage(int x, int z) {
        return this.getDrainageLayer((int)x, (int)z).valueInt;
    }

    public Rock getRockHeight(BlockPos pos) {
        return this.getRockHeight(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Rock getRockHeight(int x, int y, int z) {
        return this.getRockLayerHeight(x & 0xF, y, z & 0xF);
    }

    public int getSeaLevelOffset(BlockPos pos) {
        return this.getSeaLevelOffset(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF);
    }

    public int getSeaLevelOffset(int x, int z) {
        return this.seaLevelOffset[z << 4 | x];
    }

    public int getFishPopulation() {
        return this.fishPopulation;
    }

    public float getRainfall() {
        return this.rainfall;
    }

    public float getRegionalTemp() {
        return this.regionalTemp;
    }

    public float getAverageTemp() {
        return this.avgTemp;
    }

    public float getFloraDensity() {
        return this.floraDensity;
    }

    public float getFloraDiversity() {
        return this.floraDiversity;
    }

    public void addSpawnProtection(int multiplier) {
        if (this.protectedTicks < CalendarTFC.PLAYER_TIME.getTicks()) {
            this.protectedTicks = CalendarTFC.PLAYER_TIME.getTicks();
        }
        this.protectedTicks += (long)(multiplier * 600);
    }

    public long getSpawnProtection() {
        return this.protectedTicks - 24000L - CalendarTFC.PLAYER_TIME.getTicks();
    }

    public boolean isSpawnProtected() {
        return this.getSpawnProtection() > 0L;
    }

    public long getLastUpdateTick() {
        return this.lastUpdateTick;
    }

    public void resetLastUpdateTick() {
        this.lastUpdateTick = CalendarTFC.PLAYER_TIME.getTicks();
    }

    public long getLastUpdateYear() {
        return this.lastUpdateYear;
    }

    public void resetLastUpdateYear() {
        this.lastUpdateYear = CalendarTFC.CALENDAR_TIME.getTotalYears();
    }

    public List<Tree> getValidTrees() {
        return TFCRegistries.TREES.getValuesCollection().stream().filter(t -> t.isValidLocation(this.avgTemp, this.rainfall, this.floraDensity)).sorted((s, t) -> (int)(t.getDominance() - s.getDominance())).collect(Collectors.toList());
    }

    @Nullable
    public Tree getSparseGenTree() {
        return TFCRegistries.TREES.getValuesCollection().stream().filter(t -> t.isValidLocation(0.5f * this.avgTemp + 10.0f, 0.5f * this.rainfall + 120.0f, 0.5f)).min((s, t) -> (int)(t.getDominance() - s.getDominance())).orElse(null);
    }

    public Rock getRockLayer1(int x, int z) {
        return (Rock)((ForgeRegistry)TFCRegistries.ROCKS).getValue(this.rockLayer1[z << 4 | x]);
    }

    public Rock getRockLayer2(int x, int z) {
        return (Rock)((ForgeRegistry)TFCRegistries.ROCKS).getValue(this.rockLayer2[z << 4 | x]);
    }

    public Rock getRockLayer3(int x, int z) {
        return (Rock)((ForgeRegistry)TFCRegistries.ROCKS).getValue(this.rockLayer3[z << 4 | x]);
    }

    public DataLayer getStabilityLayer(int x, int z) {
        return this.stabilityLayer[z << 4 | x];
    }

    public DataLayer getDrainageLayer(int x, int z) {
        return this.drainageLayer[z << 4 | x];
    }

    public Rock getRockLayerHeight(int x, int y, int z) {
        int offset = this.getSeaLevelOffset(x, z);
        if (y <= 55 + offset) {
            return this.getRockLayer3(x, z);
        }
        if (y <= 110 + offset) {
            return this.getRockLayer2(x, z);
        }
        return this.getRockLayer1(x, z);
    }

    static {
        Arrays.fill(ChunkDataTFC.EMPTY.drainageLayer, DataLayer.ERROR);
        Arrays.fill(ChunkDataTFC.EMPTY.stabilityLayer, DataLayer.ERROR);
        Arrays.fill(ChunkDataTFC.EMPTY.seaLevelOffset, -1);
    }

    public static final class ChunkDataStorage
    implements Capability.IStorage<ChunkDataTFC> {
        public static NBTTagByteArray write(DataLayer[] layers) {
            return new NBTTagByteArray(Arrays.stream(layers).map(x -> (byte)x.layerID).collect(Collectors.toList()));
        }

        public static void read(DataLayer[] layers, byte[] bytes) {
            for (int i = bytes.length - 1; i >= 0; --i) {
                layers[i] = DataLayer.get(bytes[i]);
            }
        }

        @Nullable
        public NBTBase writeNBT(Capability<ChunkDataTFC> capability, ChunkDataTFC instance, EnumFacing side) {
            if (instance == null || !instance.isInitialized()) {
                return new NBTBuilder().setBoolean("valid", false).build();
            }
            NBTTagCompound root = new NBTTagCompound();
            root.func_74757_a("valid", true);
            root.func_74782_a("rockLayer1", (NBTBase)new NBTTagIntArray(instance.rockLayer1));
            root.func_74782_a("rockLayer2", (NBTBase)new NBTTagIntArray(instance.rockLayer2));
            root.func_74782_a("rockLayer3", (NBTBase)new NBTTagIntArray(instance.rockLayer3));
            root.func_74782_a("seaLevelOffset", (NBTBase)new NBTTagIntArray(instance.seaLevelOffset));
            root.func_74782_a("stabilityLayer", (NBTBase)ChunkDataStorage.write(instance.stabilityLayer));
            root.func_74782_a("drainageLayer", (NBTBase)ChunkDataStorage.write(instance.drainageLayer));
            root.func_74768_a("fishPopulation", instance.fishPopulation);
            root.func_74776_a("rainfall", instance.rainfall);
            root.func_74776_a("regionalTemp", instance.regionalTemp);
            root.func_74776_a("avgTemp", instance.avgTemp);
            root.func_74776_a("floraDensity", instance.floraDensity);
            root.func_74776_a("floraDiversity", instance.floraDiversity);
            root.func_74768_a("chunkWorkage", instance.chunkWorkage);
            root.func_74772_a("protectedTicks", instance.protectedTicks);
            root.func_74772_a("lastUpdateTick", instance.lastUpdateTick);
            root.func_74772_a("lastUpdateYear", instance.lastUpdateYear);
            NBTTagList veinList = new NBTTagList();
            for (Vein vein : instance.generatedVeins) {
                veinList.func_74742_a((NBTBase)Vein.serialize(vein));
            }
            root.func_74782_a("veins", (NBTBase)veinList);
            return root;
        }

        public void readNBT(Capability<ChunkDataTFC> capability, ChunkDataTFC instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound root = (NBTTagCompound)nbt;
            if (nbt != null && root.func_74767_n("valid")) {
                System.arraycopy(root.func_74759_k("rockLayer1"), 0, instance.rockLayer1, 0, 256);
                System.arraycopy(root.func_74759_k("rockLayer2"), 0, instance.rockLayer2, 0, 256);
                System.arraycopy(root.func_74759_k("rockLayer3"), 0, instance.rockLayer3, 0, 256);
                System.arraycopy(root.func_74759_k("seaLevelOffset"), 0, instance.seaLevelOffset, 0, 256);
                ChunkDataStorage.read(instance.stabilityLayer, root.func_74770_j("stabilityLayer"));
                ChunkDataStorage.read(instance.drainageLayer, root.func_74770_j("drainageLayer"));
                instance.fishPopulation = root.func_74762_e("fishPopulation");
                instance.rainfall = root.func_74760_g("rainfall");
                instance.regionalTemp = root.func_74760_g("regionalTemp");
                instance.avgTemp = root.func_74760_g("avgTemp");
                instance.floraDensity = root.func_74760_g("floraDensity");
                instance.floraDiversity = root.func_74760_g("floraDiversity");
                instance.chunkWorkage = root.func_74762_e("chunkWorkage");
                instance.protectedTicks = root.func_74763_f("protectedTicks");
                instance.lastUpdateTick = root.func_74763_f("lastUpdateTick");
                instance.lastUpdateYear = root.func_74763_f("lastUpdateYear");
                instance.generatedVeins = new HashSet();
                NBTTagList veinList = root.func_150295_c("veins", 10);
                for (int i = 0; i < veinList.func_74745_c(); ++i) {
                    instance.generatedVeins.add(Vein.deserialize(veinList.func_150305_b(i)));
                }
                instance.initialized = true;
            }
        }
    }
}

