/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.dries007.tfc.objects.te.TEPlacedItemFlat;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.worldgen.WorldGenOreVeins;
import net.dries007.tfc.world.classic.worldgen.vein.Vein;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenLooseRocks
implements IWorldGenerator {
    private final boolean generateOres;
    private double factor;

    public WorldGenLooseRocks(boolean generateOres) {
        this.generateOres = generateOres;
        this.factor = 1.0;
    }

    public void setFactor(double factor) {
        if (factor < 0.0) {
            factor = 0.0;
        }
        if (factor > 1.0) {
            factor = 1.0;
        }
        this.factor = factor;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (chunkGenerator instanceof ChunkGenTFC && world.field_73011_w.getDimension() == 0) {
            BlockPos chunkBlockPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
            ChunkDataTFC baseChunkData = ChunkDataTFC.get(world, chunkBlockPos);
            List<Vein> veins = Collections.emptyList();
            int xoff = chunkX * 16 + 8;
            int zoff = chunkZ * 16 + 8;
            if (this.generateOres) {
                ChunkDataTFC[] chunkData = new ChunkDataTFC[]{baseChunkData, ChunkDataTFC.get(world, chunkBlockPos.func_177982_a(16, 0, 0)), ChunkDataTFC.get(world, chunkBlockPos.func_177982_a(0, 0, 16)), ChunkDataTFC.get(world, chunkBlockPos.func_177982_a(16, 0, 16))};
                if (!chunkData[0].isInitialized()) {
                    return;
                }
                int lowestYScan = Math.max(10, world.func_175672_r(chunkBlockPos).func_177956_o() - ConfigTFC.General.WORLD.looseRockScan);
                veins = WorldGenOreVeins.getNearbyVeins(chunkX, chunkZ, world.func_72905_C(), 1);
                if (!veins.isEmpty()) {
                    veins.removeIf(v -> {
                        if (v.getType() == null || !v.getType().hasLooseRocks() || v.getHighestY() < lowestYScan) {
                            return true;
                        }
                        for (ChunkDataTFC data : chunkData) {
                            if (!data.getGeneratedVeins().contains(v)) continue;
                            return false;
                        }
                        return true;
                    });
                }
            }
            int i = 0;
            while ((double)i < (double)ConfigTFC.General.WORLD.looseRocksFrequency * this.factor) {
                BlockPos pos = new BlockPos(xoff + random.nextInt(16), 0, zoff + random.nextInt(16));
                Rock rock = baseChunkData.getRock1(pos);
                this.generateRock(world, pos.func_177981_b(world.func_175672_r(pos).func_177956_o()), this.getRandomVein(veins, pos, random), rock);
                ++i;
            }
        }
    }

    private void generateRock(World world, BlockPos pos, @Nullable Vein vein, Rock rock) {
        if (world.func_175623_d(pos) && world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && BlocksTFC.isSoil(world.func_180495_p(pos.func_177977_b()))) {
            world.func_180501_a(pos, BlocksTFC.PLACED_ITEM_FLAT.func_176223_P(), 2);
            TEPlacedItemFlat tile = Helpers.getTE((IBlockAccess)world, pos, TEPlacedItemFlat.class);
            if (tile != null) {
                ItemStack stack = ItemStack.field_190927_a;
                if (vein != null && vein.getType() != null && ConfigTFC.General.WORLD.enableLooseOres) {
                    stack = vein.getType().getLooseRockItem();
                }
                if (stack.func_190926_b() && ConfigTFC.General.WORLD.enableLooseRocks) {
                    stack = ItemRock.get(rock, 1);
                }
                if (!stack.func_190926_b()) {
                    tile.setStack(stack);
                }
            }
        }
    }

    @Nullable
    private Vein getRandomVein(List<Vein> veins, BlockPos pos, Random rand) {
        Vein vein;
        if (!veins.isEmpty() && rand.nextDouble() < 0.4 && (vein = veins.get(rand.nextInt(veins.size()))).inRange(pos.func_177958_n(), pos.func_177952_p(), 8)) {
            return vein;
        }
        return null;
    }
}

