/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.plants.BlockCactusTFC;
import net.dries007.tfc.objects.blocks.plants.BlockCreepingPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockEmergentTallWaterPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockEpiphyteTFC;
import net.dries007.tfc.objects.blocks.plants.BlockFloatingWaterTFC;
import net.dries007.tfc.objects.blocks.plants.BlockHangingPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockMushroomTFC;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockShortGrassTFC;
import net.dries007.tfc.objects.blocks.plants.BlockTallGrassTFC;
import net.dries007.tfc.objects.blocks.plants.BlockTallPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockTallWaterPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockWaterPlantTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class WorldGenPlantTFC
extends WorldGenerator {
    private Plant plant;

    public void setGeneratedPlant(Plant plantIn) {
        this.plant = plantIn;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (this.plant.getIsClayMarking()) {
            return false;
        }
        if (this.plant.getIsSwampPlant() && !BiomeDictionary.hasType((Biome)worldIn.func_180494_b(position), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return false;
        }
        switch (this.plant.getPlantType()) {
            case MUSHROOM: {
                BlockMushroomTFC plantBlock = BlockMushroomTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 16.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4));
                    if (this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) && this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) && worldIn.func_175623_d(blockpos) && plantBlock.func_176196_c(worldIn, blockpos)) {
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case SHORT_GRASS: {
                BlockShortGrassTFC plantBlock = BlockShortGrassTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 4.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    if (this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) && this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) && worldIn.func_175623_d(blockpos) && plantBlock.func_180671_f(worldIn, blockpos, state)) {
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockShortGrassTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case TALL_GRASS: {
                BlockTallGrassTFC plantBlock = BlockTallGrassTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 16.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    int j = 1 + rand.nextInt(this.plant.getMaxHeight());
                    for (int k = 0; k < j; ++k) {
                        if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos.func_177981_b(k))) || !worldIn.func_175623_d(blockpos.func_177981_b(k)) || !plantBlock.func_180671_f(worldIn, blockpos.func_177981_b(k), state)) continue;
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos.func_177981_b(k), state.func_177226_a((IProperty)BlockShortGrassTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case CREEPING: {
                BlockCreepingPlantTFC plantBlock = BlockCreepingPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 16.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4));
                    if (this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) && this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) && worldIn.func_175623_d(blockpos) && plantBlock.func_180671_f(worldIn, blockpos, state) && !BlocksTFC.isSand(worldIn.func_180495_p(blockpos.func_177977_b()))) {
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockCreepingPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case HANGING: {
                BlockHangingPlantTFC plantBlock = BlockHangingPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 4.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(16), rand.nextInt(7) - rand.nextInt(7));
                    if (this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) && this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) && worldIn.func_175623_d(blockpos) && plantBlock.func_180671_f(worldIn, blockpos, state)) {
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockHangingPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case REED: 
            case REED_SEA: {
                BlockPlantTFC plantBlock = BlockPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 16.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    if (this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) && this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) && worldIn.func_175623_d(blockpos) && worldIn.func_180495_p(blockpos.func_177977_b()).func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, blockpos.func_177977_b(), EnumFacing.UP, (IPlantable)plantBlock)) {
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case TALL_REED: 
            case TALL_REED_SEA: {
                BlockTallPlantTFC plantBlock = BlockTallPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 16.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    int j = 1 + rand.nextInt(this.plant.getMaxHeight());
                    for (int k = 0; k < j; ++k) {
                        if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos.func_177981_b(k))) || !worldIn.func_175623_d(blockpos.func_177981_b(k)) || !plantBlock.func_180671_f(worldIn, blockpos.func_177981_b(k), state)) continue;
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos.func_177981_b(k), state.func_177226_a((IProperty)BlockTallPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case DESERT: {
                BlockPlantTFC plantBlock = BlockPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position)) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    if (this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) && this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) && worldIn.func_175623_d(blockpos) && !BiomeDictionary.hasType((Biome)worldIn.func_180494_b(blockpos), (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) && plantBlock.func_180671_f(worldIn, blockpos, state)) {
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case DESERT_TALL_PLANT: {
                BlockTallPlantTFC plantBlock = BlockTallPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position)) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    int j = 1 + rand.nextInt(this.plant.getMaxHeight());
                    for (int k = 0; k < j; ++k) {
                        if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos.func_177981_b(k))) || !worldIn.func_175623_d(blockpos.func_177981_b(k)) || !plantBlock.func_180671_f(worldIn, blockpos.func_177981_b(k), state)) continue;
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos.func_177981_b(k), state.func_177226_a((IProperty)BlockTallPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case DRY: {
                BlockPlantTFC plantBlock = BlockPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position)) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    if (this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) && this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) && worldIn.func_175623_d(blockpos) && !BiomeDictionary.hasType((Biome)worldIn.func_180494_b(blockpos), (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) && plantBlock.func_180671_f(worldIn, blockpos, state)) {
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case DRY_TALL_PLANT: {
                BlockTallPlantTFC plantBlock = BlockTallPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position)) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    int j = 1 + rand.nextInt(this.plant.getMaxHeight());
                    for (int k = 0; k < j; ++k) {
                        if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos.func_177981_b(k))) || !worldIn.func_175623_d(blockpos.func_177981_b(k)) || !plantBlock.func_180671_f(worldIn, blockpos.func_177981_b(k), state)) continue;
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos.func_177981_b(k), state.func_177226_a((IProperty)BlockTallPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case TALL_PLANT: {
                BlockTallPlantTFC plantBlock = BlockTallPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 16.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    int j = 1 + rand.nextInt(this.plant.getMaxHeight());
                    for (int k = 0; k < j; ++k) {
                        if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos.func_177981_b(k))) || !worldIn.func_175623_d(blockpos.func_177981_b(k)) || !plantBlock.func_180671_f(worldIn, blockpos.func_177981_b(k), state)) continue;
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos.func_177981_b(k), state.func_177226_a((IProperty)BlockTallPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case WATER: 
            case WATER_SEA: {
                BlockWaterPlantTFC plantBlock = BlockWaterPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                IBlockState water = this.plant.getWaterType();
                int depth = this.plant.getValidWaterDepth(worldIn, position, water);
                if (depth == -1) {
                    return false;
                }
                BlockPos blockpos = position.func_177982_a(0, -depth + 1, 0);
                if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) || !plantBlock.func_176196_c(worldIn, blockpos)) break;
                int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockWaterPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                break;
            }
            case EMERGENT_TALL_WATER: 
            case EMERGENT_TALL_WATER_SEA: {
                BlockEmergentTallWaterPlantTFC plantBlock = BlockEmergentTallWaterPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                IBlockState water = this.plant.getWaterType();
                int depth = this.plant.getValidWaterDepth(worldIn, position, water);
                if (depth == -1) {
                    return false;
                }
                BlockPos blockpos = position.func_177982_a(0, -depth + 1, 0);
                if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) || !plantBlock.func_176196_c(worldIn, blockpos)) break;
                int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockEmergentTallWaterPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                if (rand.nextInt(3) >= plantAge || !plantBlock.func_176473_a(worldIn, blockpos, state, worldIn.field_72995_K)) break;
                this.func_175903_a(worldIn, blockpos.func_177984_a(), state);
                break;
            }
            case TALL_WATER: 
            case TALL_WATER_SEA: {
                BlockTallWaterPlantTFC plantBlock = BlockTallWaterPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                IBlockState water = this.plant.getWaterType();
                int depth = this.plant.getValidWaterDepth(worldIn, position, water);
                if (depth == -1) {
                    return false;
                }
                BlockPos blockpos = position.func_177982_a(0, -depth + 1, 0);
                if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) || !plantBlock.func_176196_c(worldIn, blockpos)) break;
                int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockTallPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                if (rand.nextInt(4) >= plantAge || !plantBlock.func_176473_a(worldIn, blockpos, state, worldIn.field_72995_K)) break;
                this.func_175903_a(worldIn, blockpos.func_177984_a(), state);
                break;
            }
            case FLOATING: {
                BlockFloatingWaterTFC plantBlock = BlockFloatingWaterTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                IBlockState water = this.plant.getWaterType();
                for (int i = 0; i < 8; ++i) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), 0, rand.nextInt(7) - rand.nextInt(7));
                    if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) || !worldIn.func_175623_d(blockpos) || !plantBlock.func_176196_c(worldIn, blockpos) || !this.plant.isValidFloatingWaterDepth(worldIn, blockpos, water)) continue;
                    int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                    this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockFloatingWaterTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                }
                break;
            }
            case FLOATING_SEA: {
                BlockFloatingWaterTFC plantBlock = BlockFloatingWaterTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                IBlockState water = this.plant.getWaterType();
                for (int i = 0; i < 128; ++i) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), 0, rand.nextInt(7) - rand.nextInt(7));
                    if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) || !worldIn.func_175623_d(blockpos) || !plantBlock.func_176196_c(worldIn, blockpos) || !this.plant.isValidFloatingWaterDepth(worldIn, blockpos, water)) continue;
                    int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                    this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockFloatingWaterTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                }
                break;
            }
            case CACTUS: {
                BlockCactusTFC plantBlock = BlockCactusTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 8.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    int j = 1 + rand.nextInt(this.plant.getMaxHeight());
                    for (int k = 0; k < j; ++k) {
                        if (!this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos.func_177981_b(k))) || !worldIn.func_175623_d(blockpos.func_177981_b(k)) || !plantBlock.func_180671_f(worldIn, blockpos.func_177981_b(k), state)) continue;
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos.func_177981_b(k), state.func_177226_a((IProperty)BlockCactusTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            case EPIPHYTE: {
                BlockEpiphyteTFC plantBlock = BlockEpiphyteTFC.get(this.plant);
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 4.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(16), rand.nextInt(7) - rand.nextInt(7));
                    if (this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) && this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) && worldIn.func_180495_p(blockpos).func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos) && plantBlock.func_176196_c(worldIn, blockpos)) {
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos, plantBlock.getStateForWorldGen(worldIn, blockpos).func_177226_a((IProperty)BlockEpiphyteTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break;
            }
            default: {
                BlockPlantTFC plantBlock = BlockPlantTFC.get(this.plant);
                IBlockState state = plantBlock.func_176223_P();
                int i = 0;
                while ((float)i < ChunkDataTFC.getRainfall(worldIn, position) / 16.0f) {
                    BlockPos blockpos = position.func_177982_a(rand.nextInt(7) - rand.nextInt(7), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(7) - rand.nextInt(7));
                    if (this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, blockpos)) && this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos)) && worldIn.func_175623_d(blockpos) && plantBlock.func_180671_f(worldIn, blockpos, state)) {
                        int plantAge = this.plant.getAgeForWorldgen(rand, ClimateTFC.getActualTemp(worldIn, blockpos));
                        this.func_175903_a(worldIn, blockpos, state.func_177226_a((IProperty)BlockPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)));
                    }
                    ++i;
                }
                break block0;
            }
        }
        return true;
    }
}

