/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.te.TEPlacedItemFlat;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.biomes.BiomeTFC;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenTrees
implements IWorldGenerator {
    public static void generateLooseSticks(Random rand, int chunkX, int chunkZ, World world, int amount) {
        if (ConfigTFC.General.WORLD.enableLooseSticks) {
            for (int i = 0; i < amount; ++i) {
                int x = chunkX * 16 + rand.nextInt(16) + 8;
                int z = chunkZ * 16 + rand.nextInt(16) + 8;
                BlockPos pos = world.func_175672_r(new BlockPos(x, 0, z));
                IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
                if (!world.func_175623_d(pos) || !stateDown.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) || !BlocksTFC.isGround(stateDown)) continue;
                world.func_175656_a(pos, BlocksTFC.PLACED_ITEM_FLAT.func_176223_P());
                TEPlacedItemFlat tile = (TEPlacedItemFlat)world.func_175625_s(pos);
                if (tile == null) continue;
                tile.setStack(new ItemStack(Items.field_151055_y));
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        if (!(chunkGenerator instanceof ChunkGenTFC)) {
            return;
        }
        BlockPos chunkBlockPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        ChunkDataTFC chunkData = ChunkDataTFC.get(world, chunkBlockPos);
        if (!chunkData.isInitialized()) {
            return;
        }
        Biome b = world.func_180494_b(chunkBlockPos);
        if (!(b instanceof BiomeTFC) || b == BiomesTFC.OCEAN || b == BiomesTFC.DEEP_OCEAN) {
            return;
        }
        TemplateManager manager = ((WorldServer)world).func_184163_y();
        float diversity = chunkData.getFloraDiversity();
        float density = chunkData.getFloraDensity();
        List<Tree> trees = chunkData.getValidTrees();
        Collections.rotate(trees, -((int)(diversity * ((float)trees.size() - 1.0f))));
        int stickDensity = 3 + (int)(4.0f * density + 1.5f * (float)trees.size());
        if (trees.isEmpty()) {
            stickDensity = 1 + (int)(1.5f * density);
        }
        WorldGenTrees.generateLooseSticks(random, chunkX, chunkZ, world, (int)Math.ceil((double)stickDensity * ConfigTFC.General.WORLD.sticksDensityModifier));
        if (trees.isEmpty()) {
            if (random.nextFloat() > 0.2f) {
                return;
            }
            Tree extra = chunkData.getSparseGenTree();
            if (extra != null) {
                int x = chunkX * 16 + random.nextInt(16) + 8;
                int z = chunkZ * 16 + random.nextInt(16) + 8;
                BlockPos pos = world.func_175672_r(new BlockPos(x, 0, z));
                extra.makeTree(manager, world, pos, random, true);
            }
            return;
        }
        int treesPerChunk = (int)(density * 16.0f - 2.0f);
        int maxTrees = Math.min(trees.size(), Math.min(5, (int)(1.0f + (density + diversity) * 2.5f)));
        trees = trees.subList(0, maxTrees);
        int treesPlaced = 0;
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        for (i = 0; treesPlaced < treesPerChunk && i < treesPerChunk * 3; ++i) {
            BlockPos column = new BlockPos(chunkX * 16 + random.nextInt(16) + 8, 0, chunkZ * 16 + random.nextInt(16) + 8);
            if (checkedPositions.contains(column)) continue;
            BlockPos pos = world.func_175672_r(column);
            Tree tree = this.getTree(trees, density, random);
            checkedPositions.add(column);
            if (!tree.makeTree(manager, world, pos, random, true)) continue;
            ++treesPlaced;
        }
        trees.removeIf(t -> !t.hasBushes());
        if (density > 0.6f && !trees.isEmpty()) {
            i = 0;
            while ((float)i < (float)trees.size() * 4.0f * density) {
                int x = chunkX * 16 + random.nextInt(16) + 8;
                int z = chunkZ * 16 + random.nextInt(16) + 8;
                BlockPos pos = world.func_175672_r(new BlockPos(x, 0, z));
                Tree tree = this.getTree(trees, density, random);
                ITreeGenerator bushGen = tree.getBushGen();
                if (bushGen != null && tree.hasBushes() && bushGen.canGenerateTree(world, pos, tree)) {
                    bushGen.generateTree(manager, world, pos, tree, random, true);
                }
                ++i;
            }
        }
    }

    private Tree getTree(List<Tree> trees, float density, Random random) {
        if (trees.size() == 1 || random.nextFloat() < 0.8f - density * 0.4f) {
            return trees.get(0);
        }
        return trees.get(1 + random.nextInt(trees.size() - 1));
    }
}

