/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.trees;

import com.google.common.collect.LinkedListMultimap;
import java.util.Map;
import java.util.Random;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class TreeGenComposite
implements ITreeGenerator {
    private final LinkedListMultimap<Float, ITreeGenerator> gens = LinkedListMultimap.create();
    private float totalWeight = 0.0f;

    public TreeGenComposite add(float chance, ITreeGenerator gen) {
        this.gens.put((Object)Float.valueOf(chance), (Object)gen);
        this.totalWeight += chance;
        return this;
    }

    @Override
    public void generateTree(TemplateManager manager, World world, BlockPos pos, Tree tree, Random rand, boolean isWorldGen) {
        if (this.gens.isEmpty()) {
            return;
        }
        float r = rand.nextFloat() * this.totalWeight;
        float countWeight = 0.0f;
        for (Map.Entry entry : this.gens.entries()) {
            if (!((countWeight += ((Float)entry.getKey()).floatValue()) >= r)) continue;
            ((ITreeGenerator)entry.getValue()).generateTree(manager, world, pos, tree, rand, isWorldGen);
            return;
        }
    }
}

