/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.vein;

import java.util.Random;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.world.classic.worldgen.vein.Vein;
import net.dries007.tfc.world.classic.worldgen.vein.VeinType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class VeinCluster
extends Vein {
    private final Cluster[] spawnPoints;

    public VeinCluster(BlockPos pos, VeinType veinType, Ore.Grade grade, Random rand) {
        super(pos, veinType, grade);
        double maxWidth = (0.6 + rand.nextDouble() * 0.4) * (double)veinType.getWidth();
        double maxHeight = (0.6 + rand.nextDouble() * 0.4) * (double)veinType.getHeight();
        int clusters = 4 + rand.nextInt(5);
        double maxClusterSize = 0.6 * maxWidth;
        this.spawnPoints = new Cluster[clusters];
        this.spawnPoints[0] = new Cluster(pos, maxClusterSize * (0.6 + 0.4 * rand.nextDouble()));
        for (int i = 1; i < clusters; ++i) {
            BlockPos clusterPos = pos.func_177963_a(maxWidth * 0.4 * rand.nextDouble(), maxHeight * 0.4 * rand.nextDouble(), maxWidth * 0.4 * rand.nextDouble());
            this.spawnPoints[i] = new Cluster(clusterPos, maxClusterSize * (0.4 + 0.6 * rand.nextDouble()));
        }
    }

    @Override
    public double getChanceToGenerate(BlockPos pos) {
        double shortestRadius = -1.0;
        for (Cluster c : this.spawnPoints) {
            double radius = pos.func_177951_i((Vec3i)c.pos) / c.radiusSq;
            if (shortestRadius != -1.0 && !(radius < shortestRadius)) continue;
            shortestRadius = radius;
        }
        if (shortestRadius < 0.8) {
            return this.type.getDensity();
        }
        if (shortestRadius < 1.0) {
            return this.type.getDensity() * (1.0 - shortestRadius) / 0.2;
        }
        return 0.0;
    }

    private static final class Cluster {
        final BlockPos pos;
        final double radiusSq;

        Cluster(BlockPos pos, double radius) {
            this.pos = pos;
            this.radiusSq = radius * radius;
        }
    }
}

